<?php

defined('ABSPATH') || exit;

global $post;


class Panel {
    private $form;

    public function getForm() {
        return $this->form;
    }
}

// In your code
$panel = \UtillzCore\Inc\Src\Admin\Panel::instance();
$form = $panel->getForm();
$form->set($form::Storage_Meta);
$listings = new \WP_Query([
    'post_type' => 'ulz_listing',
    'posts_per_page' => -1,
    'fields' => 'ids',
    'meta_query' => [
        'relation' => 'AND',
        [
            'key' => 'ulz_collection',
            'value' => get_the_ID(),
            'compare' => '='
        ]
    ]
]);

$listing_ids = [];
if( ! empty( $listings->posts ) ) {
    $listing_ids = $listings->posts;
}

?>

<div class="ulz-panel ulz-outer">
    <div class="ulz-section">
        <div class="ulz-form ulz-grid">
            <?php

                $form->render([
                    'type' => 'select',
                    'id' => 'collection_cover_style',
                    'name' => esc_html__('Collection cover style', 'utillz-core'),
                    'value' => 'landscape',
                    'options' => [
                        'landscape' => esc_html__('Landscape', 'utillz-core'),
                        'square' => esc_html__('Square', 'utillz-core'),
                        'portrait' => esc_html__('Portrait', 'utillz-core'),
                        'auto' => esc_html__('Automatic — Masonry', 'utillz-core'),
                    ],
                    'allow_empty' => false,
                ]);

                $form->render([
                    'type' => 'select',
                    'id' => 'collection_explore_type',
                    'name' => esc_html__('Collection page type', 'utillz-core'),
                    'options' => apply_filters('utillz/display/explore/type', [
                        'default' => esc_html__('Default', 'utillz-core'),
                    ]),
                    'allow_empty' => false,
                    'col' => 6
                ]);

                $form->render([
                    'type' => 'select',
                    'id' => 'collection_explore_columns',
                    'name' => esc_html__('Collection columns', 'utillz-core'),
                    'options' => apply_filters('utillz/display/explore/columns', [
                        5 => esc_html__('20% — Small', 'utillz-core'),
                        4 => esc_html__('25% — Medium', 'utillz-core'),
                        3 => esc_html__('33% — Large', 'utillz-core'),
                        2 => esc_html__('50% — Supersize', 'utillz-core'),
                    ]),
                    'allow_empty' => false,
                    'col' => 6
                ]);

                $form->render([
                    'type' => 'taxonomy',
                    'id' => 'listing_tag',
                    'name' => esc_html__('Collection tags', 'utillz-core'),
                    'display' => 'checklist',
                    'columns' => 2,
                ]);

                $form->render([
                    'type' => 'checklist',
                    'id' => 'listings',
                    'name' => esc_html__('Listings', 'utillz-core'),
                    'options' => [
                        'query' => [
                            'post_type' => 'ulz_listing',
                            'posts_per_page' => -1,
                        ]
                    ],
                    'value' => $listing_ids,
                    'columns' => 2,
                ]);

            ?>
        </div>
    </div>
</div>